/*    DateFormat.xs
 *
 *    $Id: DateFormat.xs,v 1.5 2001/07/20 10:23:53 mrperl Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "picu/Locale.h"
#include  "unicode/datefmt.h"
#include  "unicode/smpdtfmt.h"
#include  "unicode/timezone.h"

static int debugLevel = 0;

/*
 * Note: constant_iv returns a integer (not double)
 */
static IV
constant_iv(char *name, int arg)
{
    errno = 0;
    switch (*name) {
#if 0
add more cases as needed
    case 'A':
        break;
#endif
    case 'k':
        if (!(*(name+1))) {
            goto not_there;
        }
        switch (*(name+1)) {
            case 'A':
                if (strEQ(name, "kAmPmField"))
                    return DateFormat::kAmPmField;
                break;
            case 'D':
                if (strEQ(name, "kDateOffset"))
                    return DateFormat::kDateOffset;
                if (strEQ(name, "kDateField"))
                    return DateFormat::kDateField;
                if (strEQ(name, "kDateTime"))
                    return DateFormat::kDateTime;
                if (strEQ(name, "kDayOfWeekField"))
                    return DateFormat::kDayOfWeekField;
                if (strEQ(name, "kDayOfWeekInMonthField"))
                    return DateFormat::kDayOfWeekInMonthField;
                if (strEQ(name, "kDayOfYearField"))
                    return DateFormat::kDayOfYearField;
                if (strEQ(name, "kDefault"))
                    return DateFormat::kDefault;
                if (strEQ(name, "kDOWLocalField"))
                    return DateFormat::kDOWLocalField;
                break;
            case 'E':
                if (strEQ(name, "kEraField"))
                    return DateFormat::kEraField;
                break;
            case 'F':
                if (strEQ(name, "kFull"))
                    return DateFormat::kFull;
                break;
            case 'H':
                if (strEQ(name, "kHour0Field"))
                    return DateFormat::kHour0Field;
                if (strEQ(name, "kHour1Field"))
                    return DateFormat::kHour1Field;
                if (strEQ(name, "kHourOfDay0Field"))
                    return DateFormat::kHourOfDay0Field;
                if (strEQ(name, "kHourOfDay1Field"))
                    return DateFormat::kHourOfDay1Field;
                break;
            case 'L':
                if (strEQ(name, "kLong"))
                    return DateFormat::kLong;
                break;
            case 'M':
                if (strEQ(name, "kMedium"))
                    return DateFormat::kMedium;
                if (strEQ(name, "kMillisecondField"))
                    return DateFormat::kMillisecondField;
                if (strEQ(name, "kMinuteField"))
                    return DateFormat::kMinuteField;
                if (strEQ(name, "kMonthField"))
                    return DateFormat::kMonthField;
                break;
            case 'N':
                if (strEQ(name, "kNone"))
                    return DateFormat::kNone;
                break;
            case 'S':
                if (strEQ(name, "kSecondField"))
                    return DateFormat::kSecondField;
                if (strEQ(name, "kShort"))
                    return DateFormat::kShort;
                break;
            case 'T':
                if (strEQ(name, "kTimezoneField"))
                    return DateFormat::kTimezoneField;
                break;
            case 'W':
                if (strEQ(name, "kWeekOfMonthField"))
                    return DateFormat::kWeekOfMonthField;
                if (strEQ(name, "kWeekOfYearField"))
                    return DateFormat::kWeekOfYearField;
                break;
            case 'Y':
                if (strEQ(name, "kYearField"))
                    return DateFormat::kYearField;
                if (strEQ(name, "kYearWOYField"))
                    return DateFormat::kYearWOYField;
                break;
        }
        break;
    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

typedef enum DateFormat::EStyle DateFormat__EStyle;

MODULE = ICU::DateFormat    PACKAGE = ICU::DateFormat  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

IV
constant_iv(name,arg)
        char *name
        int   arg

DateFormat *
createInstance(CLASS)
        char *CLASS;
    CODE:
        RETVAL = DateFormat::createInstance();
    OUTPUT:
        RETVAL

DateFormat *
createDateTimeInstance(CLASS, dateStyle=DateFormat::kDefault, timeStyle=DateFormat::kDefault, locale=new Picu_Locale(&Locale::getDefault(), 0))
        char *CLASS;
        DateFormat__EStyle dateStyle;
        DateFormat__EStyle timeStyle;
        Picu_Locale *locale;
    CODE:
        RETVAL = DateFormat::createDateTimeInstance(dateStyle, timeStyle, *locale->getIcuLocale());
    OUTPUT:
        RETVAL

DateFormat *
createDateInstance(CLASS, style=DateFormat::kDefault, locale=new Picu_Locale(&Locale::getDefault(), 0))
        char *CLASS;
        DateFormat__EStyle style;
        Picu_Locale *locale;
    CODE:
        RETVAL = DateFormat::createDateInstance(style, *locale->getIcuLocale());
    OUTPUT:
        RETVAL

DateFormat *
createTimeInstance(CLASS, style=DateFormat::kDefault, locale=new Picu_Locale(&Locale::getDefault(), 0))
        char *CLASS;
        DateFormat__EStyle style;
        Picu_Locale *locale;
    CODE:
        RETVAL = DateFormat::createTimeInstance(style, *locale->getIcuLocale());
    OUTPUT:
        RETVAL

void
DateFormat::DESTROY()
    CODE:
        DEBUG100("DateFormat::DESTROY()");
	delete THIS;
        DEBUG100("DateFormat::DESTROY()");

const char *
DateFormat::format(double millis, ...)
    PREINIT:
        UnicodeString format;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        if (items > 3) {
            Perl_croak(aTHX_ "Usage: $df->format(millisec, fieldPosition=0)");
        }
        if (items == 3) {
            int index = SvIV(ST(2));
            FieldPosition fp(index);
            THIS->format(millis, format, fp);
        }
        else {
            THIS->format(millis, format);
        }
        u8str = UnicodeStringToU8String(format, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:


void
getAvailableLocales(CLASS)
        char *CLASS;
    PREINIT:
        int i;
        int32_t count;
        const Locale *locales;
    PPCODE:
    locales = DateFormat::getAvailableLocales(count);
    EXTEND(SP, count);
    for (i=0; i<count; i++) {
        SV *sv = sv_newmortal();
        Picu_Locale *ppL = new Picu_Locale(&locales[i], 0);
        sv_setref_pv(sv, Locale_class_string, (void *)ppL);
        PUSHs(sv);
    }

double
DateFormat::parse(datetime_str, ...)
        const char *datetime_str;
    PREINIT:
        UnicodeString datetime_unistr(datetime_str, "UTF-8");
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
    CODE:
        DEBUG100("items = %d", items);
        IF_DEBUG100 dump_U8String((U8*)datetime_str);
        if (items > 3) {
            Perl_croak(aTHX_ "Usage: ICU::DateFormat::parse"
                             "(datetime_str [, \\$status])");
        }
        // handle status reference
        if (items == 3) {
            if (!SVIsIntRef(ST(2))) {
                Perl_croak(aTHX_ "ICU::DateFormat::parse: param 2 must "
                                 "be an integer reference");
            }
            sv_status = SvRV(ST(2));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                XSRETURN_UNDEF;
            }
        }
        DEBUG100("status = %d", status);
        RETVAL = THIS->parse(datetime_unistr, status);
        DEBUG100("status = %d", status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
    OUTPUT:
        RETVAL

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::DateFormat::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

void
DateFormat::setTimeZone(timezone)
        TimeZone *timezone;
    CODE:
        THIS->setTimeZone(*timezone);

char *
DateFormat::toPattern()
    PREINIT:
        UnicodeString toPattern;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        ((SimpleDateFormat *)THIS)->toPattern(toPattern);
        u8str = UnicodeStringToU8String(toPattern, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:


