/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public class SimpleBlockFusionProcessor
implements BoilerpipeFilter {
    public static final SimpleBlockFusionProcessor INSTANCE = new SimpleBlockFusionProcessor();

    public static SimpleBlockFusionProcessor getInstance() {
        return INSTANCE;
    }

    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        boolean changes = false;
        if (textBlocks.size() < 2) {
            return false;
        }
        TextBlock b1 = textBlocks.get(0);
        ListIterator<TextBlock> it = textBlocks.listIterator(1);
        while (it.hasNext()) {
            boolean similar;
            TextBlock b2 = (TextBlock)it.next();
            boolean bl = similar = b1.getTextDensity() == b2.getTextDensity();
            if (similar) {
                b1.mergeNext(b2);
                it.remove();
                changes = true;
                continue;
            }
            b1 = b2;
        }
        return changes;
    }
}

