/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.filter;

import java.util.Date;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class LastModifiedLimitFilter
implements CrawlableDatasetFilter {
    private long lastModifiedLimitInMillis;

    public LastModifiedLimitFilter(long lastModifiedLimitInMillis) {
        this.lastModifiedLimitInMillis = lastModifiedLimitInMillis;
    }

    public boolean accept(CrawlableDataset dataset) {
        long now;
        Date lastModDate = dataset.lastModified();
        return lastModDate != null && (now = System.currentTimeMillis()) - lastModDate.getTime() > this.lastModifiedLimitInMillis;
    }

    public Object getConfigObject() {
        return null;
    }

    public long getLastModifiedLimitInMillis() {
        return this.lastModifiedLimitInMillis;
    }
}

