/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.TGAbstractClickUI;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GLNavigateUI
extends TGUserInterface {
    GLPanel glPanel;
    TGPanel tgPanel;
    GLNavigateMouseListener ml;
    TGAbstractDragUI hvDragUI;
    TGAbstractDragUI rotateDragUI;
    TGAbstractClickUI hvScrollToCenterUI;
    DragNodeUI dragNodeUI;
    LocalityScroll localityScroll;
    JPopupMenu nodePopup;
    JPopupMenu edgePopup;
    Node popupNode;
    Edge popupEdge;

    public GLNavigateUI(GLPanel gLPanel) {
        this.glPanel = gLPanel;
        this.tgPanel = this.glPanel.getTGPanel();
        this.localityScroll = this.glPanel.getLocalityScroll();
        this.hvDragUI = this.glPanel.getHVScroll().getHVDragUI();
        this.rotateDragUI = this.glPanel.getRotateScroll().getRotateDragUI();
        this.hvScrollToCenterUI = this.glPanel.getHVScroll().getHVScrollToCenterUI();
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.ml = new GLNavigateMouseListener();
        this.setUpNodePopup();
        this.setUpEdgePopup();
    }

    public void activate() {
        this.tgPanel.addMouseListener(this.ml);
    }

    public void deactivate() {
        this.tgPanel.removeMouseListener(this.ml);
    }

    private void setUpNodePopup() {
        this.nodePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Expand Node");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.expandNode(GLNavigateUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.nodePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Collapse Node");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.collapseNode(GLNavigateUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener2);
        this.nodePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Hide Node");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.hideNode(GLNavigateUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener3);
        this.nodePopup.add(jMenuItem);
        this.nodePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void setUpEdgePopup() {
        this.edgePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Hide Edge");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLNavigateUI.this.popupEdge != null) {
                    GLNavigateUI.this.tgPanel.hideEdge(GLNavigateUI.this.popupEdge);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.edgePopup.add(jMenuItem);
        this.edgePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverE(null);
                GLNavigateUI.this.tgPanel.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    class GLNavigateMouseListener
    extends MouseAdapter {
        GLNavigateMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.triggerPopup(mouseEvent);
            } else {
                Node node = GLNavigateUI.this.tgPanel.getMouseOverN();
                if (mouseEvent.getModifiers() == 16) {
                    if (node == null) {
                        GLNavigateUI.this.hvDragUI.activate(mouseEvent);
                    } else {
                        GLNavigateUI.this.dragNodeUI.activate(mouseEvent);
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Node node = GLNavigateUI.this.tgPanel.getMouseOverN();
            if (mouseEvent.getModifiers() == 16 && node != null) {
                GLNavigateUI.this.tgPanel.setSelect(node);
                try {
                    GLNavigateUI.this.tgPanel.setLocale(node, GLNavigateUI.this.localityScroll.getLocalityRadius());
                }
                catch (TGException tGException) {
                    System.out.println("Error setting locale");
                    tGException.printStackTrace();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.triggerPopup(mouseEvent);
            }
        }

        private void triggerPopup(MouseEvent mouseEvent) {
            GLNavigateUI.this.popupNode = GLNavigateUI.this.tgPanel.getMouseOverN();
            GLNavigateUI.this.popupEdge = GLNavigateUI.this.tgPanel.getMouseOverE();
            if (GLNavigateUI.this.popupNode != null) {
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                GLNavigateUI.this.nodePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (GLNavigateUI.this.popupEdge != null) {
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                GLNavigateUI.this.edgePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                GLNavigateUI.this.glPanel.glPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

