package App::InteractivePerlTutorial::Chapter::Scalar::Numbers;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Numbers';

1;
__DATA__

=encoding utf-8

=head1 Numbers

Perl does computations with double-precision floating point numbers. You can represent a number literally in your script, for example:

  2
  -10
  3.81
  9.23
  1e10 # 10000000000 in scientific notation
  -7.231E3 # -723.1 in scientific notation

Literals need not be decimal. You can also have hexadecimal literals, which start with 0x, octal literals which start with 0, binary literals which start with 0b, for example:

  0xFF # 255
  0377 # also 255
  0b11111111 # also 255

You can insert underscores for clarity within literals. They will be ignored by Perl.

  100_000_000
  22_141_796
  0x134_222_333
  0b1011_0101_0101

You can do basic math on numbers, for example:

  1 + 1.5 # 1 plus 1.5, which is 2.5
  20 - 5  # 20 minus 5, which is 15
  4 * 7.2 # 4 times 7.2, which is 28.8
  10 / 2  # 10 divided by 2, which is 5
  7 / 1.2 # 7 divided by 1.2, which is 5.83333...
  20 % 3  # the remainder when 20 is divided by 3, or 2
  11 ** 2 # 11 to the second power, which is 121


=cut
